#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include <Windows.H>
#include <Stdio.H>
#include <CommCtrl.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Package.H"
#include "../Source/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/ReadingDlg.H"
#include "../Dialogs/PackingDlg.H"
#include "../Dialogs/ExtractDlg.H"
#include "../Dialogs/OpenPassDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MainDialog_hWnd = NULL;
HWND FileList_hWnd = NULL;
HWND StatusBar_hWnd = NULL;

HIMAGELIST LV_MainDlgImageList = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HBRUSH BGColor = CreateSolidBrush( RGB(214, 211, 206) );

int SortCol = -1;
int SortUpOrDown = -1;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define IDM_NEW        1000
#define IDM_OPEN       1001
#define IDM_ADD        1002
#define IDM_DELETE     1003
#define IDM_EXTRACT    1004
#define IDM_VIEW       1005
#define IDM_PROPERTIES 1006
#define IDM_OPTIONS    1007
#define IDM_HELP       1008
#define IDM_EXIT       1009

#define ID_MYTOOLBAR   2000

#define BTIcons        10
#define TBButtons      13
#define TBLength       36
#define TBWidth        36

#define SORT_UP        1
#define SORT_DOWN      2

#define COL_STRING     1
#define COL_INTEGER    2
#define COL_DOUBLE     3
#define COL_DATE       4

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

TBBUTTON tbb[] = {
    {0, IDM_NEW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {1, IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {2, IDM_ADD, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {3, IDM_DELETE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {4, IDM_EXTRACT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {5, IDM_VIEW, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {6, IDM_PROPERTIES, 0, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {7, IDM_OPTIONS, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {8, IDM_HELP, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {9, IDM_EXIT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0}
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HWND CreateToolBar(HWND hWnd)
{
    HWND hTool     = NULL;
    HBITMAP BitMap = NULL;

    InitCommonControls();

    if(! (BitMap = LoadBitmap(ghAppInstance, MAKEINTRESOURCE(IDB_TOOLBAR) )) )
        ErrorMessage(hWnd, "Failed to load bitmap");

    hTool = CreateToolbarEx(
        hWnd,
        WS_CHILD|WS_VISIBLE|TBSTYLE_TOOLTIPS|TBSTYLE_FLAT|TBSTYLE_TOOLTIPS|TBSTYLE_BUTTON,
        ID_MYTOOLBAR,
        BTIcons,
        NULL,
        (DWORD)BitMap,
        tbb,
        0,
        TBLength, TBWidth,
        TBLength, TBWidth,
        sizeof(TBBUTTON)
    );

	tbb[0].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "New");
    tbb[1].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Open");

    tbb[3].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Add");
    tbb[4].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Delete");
    tbb[5].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Extract");

    tbb[7].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "View");
    tbb[8].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Properties");

    tbb[10].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Options");
    tbb[11].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Help");
    tbb[12].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Exit");

    SendMessage(hTool, TB_ADDBUTTONS, TBButtons, (LONG)&tbb);
    SendMessage(hTool, TB_AUTOSIZE, 0, 0);

    return hTool;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _tagSORTDATA{
    HWND hwndList;
    int isortSubItem;
    int iUPDOWN;
    int iColType;
} SORTDATA;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

double fFormattedValue(char *sFormatted)
{
    int Length = strlen(sFormatted);
    int RPos = 0;
    int WPos = 0;

    char sVal[32];

	while(RPos < Length)
    {
        if(sFormatted[RPos] == ',')
            RPos++;

        if((sFormatted[RPos] < 48 || sFormatted[RPos] > 57) && sFormatted[RPos] != '.')
            break;

        sVal[WPos] = sFormatted[RPos];
        RPos++;
        WPos++;
    }
    sVal[WPos] = '\0';

    return atof(sVal);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int iFormattedValue(char *sFormatted)
{
    int Length = strlen(sFormatted);
    int RPos = 0;
    int WPos = 0;

    char sVal[32];

    if(Length <= 3)
    {
        return atol(sFormatted);
    }

	while(RPos < Length)
    {
        if(sFormatted[RPos] == ',')
            RPos++;

        if(sFormatted[RPos] < 48 || sFormatted[RPos] > 57)
            break;

        sVal[WPos] = sFormatted[RPos];
        RPos++;
        WPos++;
    }
    sVal[WPos] = '\0';

    return atol(sVal);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CALLBACK CompListEx(LPARAM lParam1, LPARAM lParam2, LPARAM lParam3)
{
    char buf1[MAX_PATH];
    char buf2[MAX_PATH];

    int RetVal = 0;

    SORTDATA *lpsd;

    lpsd = (SORTDATA *)lParam3;

    ListView_GetItemText(lpsd->hwndList, lParam1, (int)lpsd->isortSubItem, buf1, sizeof(buf1));
    ListView_GetItemText(lpsd->hwndList, lParam2, (int)lpsd->isortSubItem, buf2, sizeof(buf2));

    if(lpsd->iColType == COL_STRING)
    {
        RetVal = strcmpi(buf1, buf2);
    }
    else if(lpsd->iColType == COL_INTEGER)
    {
        int Val1 = iFormattedValue(buf1);
        int Val2 = iFormattedValue(buf2);

        if(Val1 > Val2)
            RetVal = 1;
        else if(Val1 < Val2)
            RetVal = -1;
        else return 0;
    }
    else if(lpsd->iColType == COL_DOUBLE)
    {
        double Val1 = fFormattedValue(buf1);
        double Val2 = fFormattedValue(buf2);

        if(Val1 > Val2)
            RetVal = 1;
        else if(Val1 < Val2)
            RetVal = -1;
        else return 0;
    }

    if(RetVal == 0)
        return 0;

    if(lpsd->iUPDOWN == SORT_DOWN)
    {
        if(RetVal == 1)
            return -1;
        else return 1;
    }
    else return RetVal;

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CALLBACK CompList(LPARAM lParam1, LPARAM lParam2, LPARAM lParam3)
{
    int RetVal = 0;
    SORTDATA *lpsd;

    lpsd = (SORTDATA *)lParam3;

    if(lParam1 > lParam2)
        RetVal = 1;
    else if(lParam1 < lParam2)
        RetVal = -1;
    else return 0;

    if(lpsd->iUPDOWN == SORT_DOWN)
    {
        if(RetVal == 1)
            return -1;
        else return 1;
    }
    else return RetVal;

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;
    static HWND MainToolBar_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        FileList_hWnd = GetDlgItem(xHandle, IDC_FILELIST);
        MainToolBar_hWnd = CreateToolBar(xHandle);

        SendMessage(FileList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
        ListView_SetTextColor(FileList_hWnd, RGB(0,0,100));

        LV_COLUMN MyLVColumb;

        memset(&MyLVColumb, 0, sizeof(LV_COLUMN));

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Name";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Type";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 1, &MyLVColumb);

        MyLVColumb.cx        = 125;
        MyLVColumb.pszText   = "Modified";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 2, &MyLVColumb);

        MyLVColumb.cx        = 65;
        MyLVColumb.pszText   = "Size";
        MyLVColumb.iSubItem  = 3;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_RIGHT;
        ListView_InsertColumn(FileList_hWnd, 3, &MyLVColumb);

        MyLVColumb.cx        = 50;
        MyLVColumb.pszText   = "Ratio";
        MyLVColumb.iSubItem  = 4;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 4, &MyLVColumb);

        MyLVColumb.cx        = 65;
        MyLVColumb.pszText   = "Packed";
        MyLVColumb.iSubItem  = 5;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_RIGHT;
        ListView_InsertColumn(FileList_hWnd, 5, &MyLVColumb);

        MyLVColumb.cx        = 75;
        MyLVColumb.pszText   = "CRC";
        MyLVColumb.iSubItem  = 6;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 6, &MyLVColumb);

        MyLVColumb.cx        = 75;
        MyLVColumb.pszText   = "Attributes";
        MyLVColumb.iSubItem  = 7;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 7, &MyLVColumb);

        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Path";
        MyLVColumb.iSubItem  = 8;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 8, &MyLVColumb);

        MyLVColumb.cx        = 0;
        MyLVColumb.pszText   = "Position";
        MyLVColumb.iSubItem  = 9;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM | LVCF_FMT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(FileList_hWnd, 9, &MyLVColumb);

		LV_MainDlgImageList = ImageList_Create( GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), ILC_COLORDDB, 1, 100);
        ListView_SetImageList(FileList_hWnd, LV_MainDlgImageList, LVSIL_SMALL);

        StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);

        int Widths[] = {200, -1};

        SendMessage(StatusBar_hWnd, (UINT)SB_SETPARTS, (WPARAM)2, (LPARAM)&Widths);

        CenterWindow(xHandle);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(FileList_hWnd, 0, 70, WindowRECT.right, WindowRECT.bottom - 91, TRUE);
        MoveWindow(StatusBar_hWnd, WindowRECT.right-20, WindowRECT.bottom-20, WindowRECT.right, WindowRECT.bottom, TRUE);

        if(gdwCurrentJobType == JOB_TYPE_READING)
        {
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_READING), NULL, ReadingDialog) != 1)
            {
                ImageList_Destroy(LV_MainDlgImageList);
                EndDialog(xHandle, 0);
                DestroyWindow(xHandle);
            }
        }
        else if(gdwCurrentJobType == JOB_TYPE_PACKING_DIR || gdwCurrentJobType == JOB_TYPE_PACKING_FIL) {
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PACKING), NULL, PackingDialog) != 1)
            {
                ImageList_Destroy(LV_MainDlgImageList);
                EndDialog(xHandle, 0);
                DestroyWindow(xHandle);
            }
            else {
                // View an existing archive
                gdwCurrentJobType = JOB_TYPE_READING;
                hWorker_Thread_Handle = CreateThread(NULL, 0, ViewExisting_Worker_Thread, (LPVOID) gsWorkingOutput, CREATE_SUSPENDED, &dwWorker_Thread_ID);
                if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_READING), xHandle, ReadingDialog) != 1)
                {
                    ImageList_Destroy(LV_MainDlgImageList);
                    EndDialog(xHandle, 0);
                    DestroyWindow(xHandle);
                }
                ArchiveOpen = true;
            }
        }
        else{
            ResumeThread(hWorker_Thread_Handle);
        }

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DROPFILES)
    {

        HDROP hFilesInfo = (HDROP)wParam;
        int wTotalFiles;
        int wIndex;
        char szFileName[MAX_PATH + 1];

        wTotalFiles = DragQueryFile(hFilesInfo, -1, NULL, 0);

        MessageBox(xHandle, IntChar(wTotalFiles), gsTitleCaption, 0);

        wIndex = 0;

        while(wIndex < wTotalFiles)
        {
            DragQueryFile(hFilesInfo, wIndex, (LPSTR)szFileName, MAX_PATH);
            MessageBox(xHandle, szFileName, gsTitleCaption, 0);
            wIndex++;
        }

        DragFinish(hFilesInfo);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORDLG)
        return (LONG)BGColor;

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);

        MoveWindow(FileList_hWnd, 0, 70, nWidth, nHeight - 91, TRUE);
        MoveWindow(StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);

        SendMessage(MainToolBar_hWnd, TB_AUTOSIZE, 0, 0);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDM_NEW)
        {
            PlaySound(MAKEINTRESOURCE(IDR_TICKWAVE), ghAppInstance, SND_ASYNC|SND_RESOURCE);

            ArchiveOpen = false;

            gdwCurrentJobType = 0;

            memset(gsArchiveName, 0, sizeof(gsArchiveName));
            memset(gsLastExtractLocation, 0, sizeof(gsLastExtractLocation));
            memset(gsWorkingOutput, 0, sizeof(gsWorkingOutput));

            ListView_DeleteAllItems(FileList_hWnd);

            return TRUE;
        }

        if(wParam == IDM_OPEN)
        {
            PlaySound(MAKEINTRESOURCE(IDR_TICKWAVE), ghAppInstance, SND_ASYNC|SND_RESOURCE);

            char *DefaultExtension = NULL;
            char *Filters = "Project-Epsilon-Files\0*.PCE\0All-Files\0*.*\0\0";
            char InitialDirectory[MAX_PATH + 1];

            GetCurrentDirectory(MAX_PATH, InitialDirectory);

            if(OSFileDialog(xHandle, gsArchiveName, ".PCE", "Select an archive to open", Filters, InitialDirectory, OFD, OFN_EXPLORER + OFN_LONGNAMES + OFN_PATHMUSTEXIST))
            {
                // View an existing archive
                gdwCurrentJobType = JOB_TYPE_READING;
                if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_OPENPASS), xHandle, OpenPassDialog) != 1)
                {
                    return TRUE;
                }

                ShowWindow(xHandle, SW_HIDE);
                ListView_DeleteAllItems(FileList_hWnd);
                hWorker_Thread_Handle = CreateThread(NULL, 0, ViewExisting_Worker_Thread, (LPVOID) gsArchiveName, CREATE_SUSPENDED, &dwWorker_Thread_ID);
                if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_READING), xHandle, ReadingDialog) != 1)
                {
                    ListView_DeleteAllItems(FileList_hWnd);
                }
                ShowWindow(xHandle, SW_SHOW);
            }

            return TRUE;
        }

        if(wParam == IDM_EXTRACT)
        {
            PlaySound(MAKEINTRESOURCE(IDR_TICKWAVE), ghAppInstance, SND_ASYNC|SND_RESOURCE);

            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_EXTRACT), xHandle, ExtractDialog) == 1)
            {
                hWorker_Thread_Handle = CreateThread(NULL, 0, ExtractEntireArchive_Worker_Thread, (LPVOID) gsArchiveName, CREATE_SUSPENDED, &dwWorker_Thread_ID);
                DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PACKING), xHandle, PackingDialog);
            }

            return TRUE;
        }

        if(wParam == IDM_HELP)
        {
            PlaySound(MAKEINTRESOURCE(IDR_TICKWAVE), ghAppInstance, SND_ASYNC|SND_RESOURCE);

            int Value = ListView_GetSelectedCount(FileList_hWnd);

            int ItemPos = -1;
            while( (ItemPos = ListView_GetNextItem(FileList_hWnd, ItemPos, LVNI_SELECTED)) != -1)
            {
                char FileName[255 + 1];
                char FullFileName[255 + 1];
                char Path[255 + 1];

                ListView_GetItemText(FileList_hWnd, ItemPos, 0, FileName, 255);
                ListView_GetItemText(FileList_hWnd, ItemPos, 8, Path, 255);

                _makepath(FullFileName, NULL, Path, FileName, NULL);

                MessageBox(xHandle, FullFileName, Path, 0);
            }

            return TRUE;
        }

        if(wParam == IDM_EXIT)
        {
            PlaySound(MAKEINTRESOURCE(IDR_TICKWAVE), ghAppInstance, SND_ASYNC|SND_RESOURCE);

            ImageList_Destroy(LV_MainDlgImageList);
            EndDialog(xHandle, 0);
            DestroyWindow(xHandle);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------
	if(xMessage == WM_NOTIFY)
    {
        LPNMHDR lpnmhdr = (LPNMHDR)lParam;
        if (lpnmhdr->hwndFrom == FileList_hWnd)
        {
            int iSortSubItem = 0;
            LVCOLUMN MyLVColumn;
            NMLISTVIEW  *pNMLV;
            SORTDATA SortData;
			int iIndex = 0;
            char ColName[64];

            switch (lpnmhdr->code)
            {
                case NM_DBLCLK:

                    iIndex = ListView_GetNextItem(FileList_hWnd, -1, LVNI_SELECTED);
                    MessageBox(xHandle, IntChar(iIndex), gsTitleCaption, 0);
                    break;

                case LVN_COLUMNCLICK:
                    pNMLV = (NMLISTVIEW *)lParam;
                    iSortSubItem = pNMLV->iSubItem;

                    memset(&SortData, 0, sizeof(SortData));
                    memset(&MyLVColumn, 0, sizeof(&MyLVColumn));

                    if(SortCol == iSortSubItem)
                    {
                        if(SortUpOrDown == SORT_UP)
                            SortUpOrDown = SORT_DOWN;
                        else SortUpOrDown = SORT_UP;
                    }
                    else {
                        SortCol = iSortSubItem;
                        SortUpOrDown = SORT_UP;
                    }

                    SortData.hwndList = FileList_hWnd;
                    SortData.isortSubItem = SortCol;
                    SortData.iUPDOWN = SortUpOrDown;

                    MyLVColumn.mask = LVCF_TEXT;
                    MyLVColumn.pszText = ColName;
                    MyLVColumn.cchTextMax = sizeof(ColName);

                    if(ListView_GetColumn(FileList_hWnd, iSortSubItem, &MyLVColumn))
                    {
                        if(strcmpi(ColName, "Name") == 0)
                            SortData.iColType = COL_STRING;
                        else if(strcmpi(ColName, "Type") == 0)
                            SortData.iColType = COL_STRING;
                        else if(strcmpi(ColName, "Modified") == 0)
                            SortData.iColType = COL_DATE;
                        else if(strcmpi(ColName, "Size") == 0)
                            SortData.iColType = COL_INTEGER;
                        else if(strcmpi(ColName, "Packed") == 0)
                            SortData.iColType = COL_INTEGER;
                        else if(strcmpi(ColName, "Ratio") == 0)
                            SortData.iColType = COL_DOUBLE;
                        else if(strcmpi(ColName, "CRC") == 0)
                            SortData.iColType = COL_STRING;
                        else if(strcmpi(ColName, "Attributes") == 0)
                            SortData.iColType = COL_STRING;
                        else if(strcmpi(ColName, "Path") == 0)
                            SortData.iColType = COL_STRING;
                        else if(strcmpi(ColName, "Position") == 0)
                            SortData.iColType = COL_INTEGER;
                        else SortData.iColType = 0;

                        if(SortData.iColType == COL_DATE)
                        {
                            ListView_SortItems(FileList_hWnd, CompList, (LPARAM)&SortData);
                        }
                        else if(SortData.iColType != 0)
                        {
                            ListView_SortItemsEx(FileList_hWnd, CompListEx, (LPARAM)&SortData);
                        }
                    }

                    break;
			}
        }

        return TRUE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        ImageList_Destroy(LV_MainDlgImageList);
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

